/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.onboarding;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;

public abstract class OnboardingScreenBase
extends Screen {
    public static final Component NEXT = Component.translatable((String)"message.voicechat.onboarding.next");
    public static final Component BACK = Component.translatable((String)"message.voicechat.onboarding.back");
    public static final Component CANCEL = Component.translatable((String)"message.voicechat.onboarding.cancel");
    protected static final int TEXT_COLOR = -1;
    protected static final int PADDING = 8;
    protected static final int SMALL_PADDING = 2;
    protected static final int BUTTON_HEIGHT = 20;
    protected int contentWidth;
    protected int guiLeft;
    protected int guiTop;
    protected int contentHeight;
    @Nullable
    protected Screen previous;

    public OnboardingScreenBase(Component title, @Nullable Screen previous) {
        super(title);
        this.previous = previous;
    }

    protected void init() {
        super.init();
        this.contentWidth = this.width / 2;
        this.guiLeft = (this.width - this.contentWidth) / 2;
        this.guiTop = 20;
        this.contentHeight = this.height - this.guiTop * 2;
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
    }

    @Nullable
    public Screen getNextScreen() {
        return null;
    }

    protected void addPositiveButton(Component text, Button.OnPress onPress) {
        Button nextButton = Button.builder((Component)text, (Button.OnPress)onPress).bounds(this.guiLeft + this.contentWidth / 2 + 4, this.guiTop + this.contentHeight - 20, this.contentWidth / 2 - 4, 20).build();
        this.addRenderableWidget((GuiEventListener)nextButton);
    }

    protected void addNextButton() {
        this.addPositiveButton(NEXT, button -> this.minecraft.setScreen(this.getNextScreen()));
    }

    protected void addBackOrCancelButton(boolean big) {
        Component text = CANCEL;
        if (this.previous instanceof OnboardingScreenBase) {
            text = BACK;
        }
        Button cancel = Button.builder((Component)text, button -> this.minecraft.setScreen(this.previous)).bounds(this.guiLeft, this.guiTop + this.contentHeight - 20, big ? this.contentWidth : this.contentWidth / 2 - 4, 20).build();
        this.addRenderableWidget((GuiEventListener)cancel);
    }

    protected void addBackOrCancelButton() {
        this.addBackOrCancelButton(false);
    }

    protected void renderTitle(GuiGraphics guiGraphics, Component titleComponent) {
        int titleWidth = this.font.width((FormattedText)titleComponent);
        guiGraphics.drawString(this.font, titleComponent.getVisualOrderText(), this.width / 2 - titleWidth / 2, this.guiTop, -1, true);
    }

    protected void renderMultilineText(GuiGraphics guiGraphics, Component textComponent) {
        List text = this.font.split((FormattedText)textComponent, this.contentWidth);
        for (int i = 0; i < text.size(); ++i) {
            FormattedCharSequence line = (FormattedCharSequence)text.get(i);
            int n = this.width / 2 - this.font.width(line) / 2;
            Objects.requireNonNull(this.font);
            Objects.requireNonNull(this.font);
            guiGraphics.drawString(this.font, line, n, this.guiTop + 9 + 20 + i * (9 + 1), -1, true);
        }
    }
}

